*** COS 2023 01, last update 2023 01  
           
program define dq_int_var2, rclass  
syntax , [varchecklist(string) row(string) vartype(int 1) tablename(string) recodeminprop(real .95) stringvars(string)] $syntax_analysissettings $syntax_debugging  
if "`tablename'"==""  	local tablename="integtable_studydata"  
if "`row'"==""  		local tablename="integtablerows_studydata"  
local indent=`indent'+5  
local adoname "dq_int_var2"  
local adofullname "Integrity check data type"  
local text_i "di as text _n "  					  
local vartypetext vt_`vartype'  
local reportstop=0  
	          
tokenize `varchecklist'  
while "`1'"~="" {  
	local var "`1'"  
	          
	local var_statatype 	`: type `var''								  
	local var_format 		`: format `var''							  
	local vartype_issue = 0												  
	local convert=0														  
	local convertsuccess=0												  
	scalar var2_dt_$$`var'= 1											  
	          
	capture confirm scalar data_type_$$`var'  
	if _rc>0   {  
		         
		* Assign a scalar from the variable if no metadata existent but not yet for string because this may be converted  
		if strpos("`var_format'","%t")>0 														scalar data_type_$$`var'= "datetime $assigned_1"  
		if strpos("`var_format'","%t")==0 & strpos("integer byte long","`var_statatype'")>0  	scalar data_type_$$`var'= "integer $assigned_1"  
		if strpos("`var_format'","%t")==0 & strpos("float double","`var_statatype'")>0  		scalar data_type_$$`var'= "float $assigned_1"  
		if strpos("`var_statatype'","str")>0  													scalar data_type_$$`var'= "string $assigned_1"  
		         
		if `vartype'==5 	scalar data_type_$$`var'= "datetime $assigned_1"		  
	          
		if strpos("`var_statatype'","str")>0 & `vartype'~=12 {  
			local convert=1  
			`text_i' "String variable detected in pipeline for numeric variables" _n  
			dq_out_add,  tablename("`tablename'") row(`row') columns(3) colcontent1("$Note_1") colcontent2("$`vartypetext' `var'") ///  
						 colcontent3($DQ_INT_note_26) vartype(`vartype')  indent(`indent')		  
		}        
	}         
	          
	local var_expect  =	"`=data_type_$$`var''"				  
	if strpos("`var_expect'","string")>0 	& strpos("`var_statatype'","str")>0 {  
		if `vartype'==6 | `vartype'==7 | `vartype'==8  local convert=1					  
	}         
	if strpos("`var_expect'","string")>0 	& strpos("`var_statatype'","str")==0 				local vartype_issue = 1		  
	if strpos("`var_expect'","datetime")>0 	& strpos("`var_format'","%t")==0 					local vartype_issue = 1		  
	if strpos("`var_expect'","string")==0 	& strpos("`var_statatype'","str")>0 	{  
		local vartype_issue = 1	  
		local convert=1  
	}							  
	if strpos("`var_expect'","integer")>0 	& strpos("float double","`var_statatype'")>0 		local vartype_issue = 1						  
	if strpos("`var_expect'","float")>0		& strpos("integer byte long","`var_statatype'")>0 	local vartype_issue = 1		  
	          
	if `vartype_issue'==1 {  
	    di    
		`text_i' "Data Quality Classification for `var':  Indicator: Data type mismatch; Implementation form: `var_statatype' `var_format' where `var_expect' expected"  
		scalar var2_dt_$$`var'= 1			  
		dq_out_add,  tablename("`tablename'") row(`row') columns(3) colcontent1("$Warning_1") colcontent2("$`vartypetext' `var'") ///  
					 colcontent3($DQ_INT_issue_9: $expected_1: `var_expect' $observed_1: `var_statatype' `var_format') vartype(`vartype')  indent(`indent')				  
	}         
	          
	if `vartype'~=5 {  
		* 1. With data_type metadata: A numeric variable that is observed as being a string variables  
		* 2. Without data_type metadata: Any string variable  
		if `convert'==1 {  
				local recodeminprop_pass=`recodeminprop'  
				if `vartype'==6 | `vartype'==7 | `vartype'==8  local recodeminprop_pass=0  
				dq_dm_stn `var', recodeminprop(`recodeminprop_pass') tablename(integtable_studydata) row(integtablerows_studydata)   indent(`indent')  
				local convertsuccess="`r(convertsuccess)'"  
		}        
	}         
	if `vartype'==5 {  
		dq_dm_dat `var',  indent(`indent')			  
		local convertsuccess="`r(convertsuccess)'"  
		if `convertsuccess'==0 {  
		    local remove_time =trim("`remove_time' `var'")  
		}        
	}         
	if `convertsuccess'>0 {  
		local var_statatype 	`: type   `var''							  
		local var_format 		`: format `var''							  
		* Reassign data type and overwrite assignement from dq_int_var2  
		if strpos("integer byte long","`var_statatype'")>0  scalar data_type_$$`var'= "integer ($converted_1)"  
		if strpos("float double","`var_statatype'")>0  		scalar data_type_$$`var'= "float ($converted_1)"			  
	}         
	          
	scalar data_revised_format_$$`var'= "`var_statatype' `var_format'"	  
	if strpos("`var_statatype'","str")>0 local stringvars=trim("`stringvars' `var'")			  
	* Create scalar for changed variable type  
	if "`=data_original_format_$$`var''"~="`=data_revised_format_$$`var''" scalar data_change_format_$$`var'="`=data_original_format_$$`var'' $converted_1: `=data_revised_format_$$`var''"  
	if "`=data_original_format_$$`var''"=="`=data_revised_format_$$`var''" scalar data_change_format_$$`var'="`=data_original_format_$$`var''"  
	          
	if "`=data_original_format_$$`var''"~="`=data_revised_format_$$`var''" & `convertsuccess'==0 {  
			dq_out_add,  tablename("`tablename'") row(`row') columns(3) colcontent1("$Note_1") colcontent2("$`vartypetext' `var'") ///  
					 colcontent3($DQ_INT_note_28 `=data_change_format_$$`var'') vartype(`vartype')  indent(`indent')  
	}         
   macro shift															  
           
}	         
return local stringvars="`stringvars'"  
return local remove_time="`remove_time'"  
return local reportstop="`reportstop'"  
end        
